/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.fddi;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.common.Boolean;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionFddiMac
implements StatusMapper,
TableStatusNamer {
    private static String fddiBundle = "ibm.nways.fddi.Resources";
    private boolean loggingOn = false;

    public ActionFddiMac() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionFddiMac");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        int n2 = (Integer)serializableArray[1];
        if (this.loggingOn) {
            System.out.println("MacDupAddress = " + statusModelInfo.get("Panel.FddimibMACDupAddressTest"));
            System.out.println("MacFrameError = " + statusModelInfo.get("Panel.FddimibMACFrameErrorFlag"));
        }
        Integer n3 = (Integer)statusModelInfo.get("Panel.FddimibMACDupAddressTest");
        Boolean boolean_ = (Boolean)statusModelInfo.get("Panel.FddimibMACFrameErrorFlag");
        int n4 = n3;
        StatusAndExplain statusAndExplain = this.evaluateDupAddressAndFrameError(n4, boolean_, n, n2);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionFddiMac - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(fddiBundle, "STATUS_NAME_MAC", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionFDDIMac - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(fddiBundle, "STATUS_TABLE_MAC");
        return i18NString;
    }

    private StatusAndExplain evaluateDupAddressAndFrameError(int n, Boolean boolean_, int n2, int n3) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n2), new Integer(n3)};
        if (n == 3) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[0] = new I18NMsgFormat(fddiBundle, "dupstatus", objectArray2);
            objectArray[1] = new I18NString(fddiBundle, "true");
        } else if (boolean_.equals("true")) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[0] = new I18NMsgFormat(fddiBundle, "framestatus", objectArray2);
            objectArray[1] = new I18NString(fddiBundle, "true");
        } else {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[0] = new I18NMsgFormat(fddiBundle, "framestatus", objectArray2);
            objectArray[1] = new I18NString(fddiBundle, "false");
        }
        statusAndExplain.explain = new I18NGiblets(fddiBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("statType = " + statusAndExplain.statType);
            System.out.println("explain  = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionFddiMac.this = ActionFddiMac.this;
        }
    }
}

